package com.example.samplelogin

import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.text.Editable
import android.text.TextWatcher
import android.util.Log
import android.widget.Toast
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.example.samplelogin.databinding.ActivityMainBinding

class MainActivity : AppCompatActivity() {

    private lateinit var binding: ActivityMainBinding
    private lateinit var viewModel: MainViewModel

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)

        viewModel = ViewModelProvider(this).get(MainViewModel::class.java)

        binding.btnRegister.setOnClickListener {
            startWelcomeScreen()
        }

        binding.etUsername.addTextChangedListener(watchText(6, "username"))
        binding.etPassword.addTextChangedListener(watchText(8, "password"))

        viewModel.eventRequirementMatched.observe(this, Observer { hasMatched ->
            binding.btnRegister.isEnabled = hasMatched
        })
    }

    private fun startWelcomeScreen() {
        val intent = Intent(this, WelcomeActivity::class.java).also {
            it.putExtra("username", binding.etUsername.text.toString())
            startActivity(it)
        }
    }

    private fun watchText (charMin : Int, fieldName: String) : TextWatcher {
        val textWatcher = object : TextWatcher {
            override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {
            }
            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
            }
            override fun afterTextChanged(s: Editable?) {
                viewModel.checkField(s.toString().length, charMin, fieldName)
            }
        }
        return textWatcher
    }


}