package com.example.samplelogin

import android.util.Log
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel

class MainViewModel : ViewModel() {

    private val _usernameMatched = MutableLiveData<Boolean>()
    private val _passwordMatched = MutableLiveData<Boolean>()

    private val _eventRequirementMatched = MutableLiveData<Boolean>()
    val eventRequirementMatched: LiveData<Boolean>
        get() = _eventRequirementMatched


    init {
        Log.i("MainViewModel", "MainViewModel created")
        _usernameMatched.value = false
        _passwordMatched.value = false
        _eventRequirementMatched.value = false
    }

    fun checkField (length: Int, charMin: Int, fieldName: String) {
        var field: MutableLiveData<Boolean> = when (fieldName) {
            "username" -> _usernameMatched
            "password" -> _passwordMatched
            else -> return
        }

        field.value = length >= charMin
        _eventRequirementMatched.value = _usernameMatched.value  == true && _passwordMatched.value == true
    }
}